; vim: set ts=4 sw=4 sts=4 expandtab: =========================================;
;                  [ 御殿谷サキ from ヴァンガードプリンセス ]                  ;
;==============================================================================;

;------------------------------------------------------------------------------;
; ボタン配置
;------------------------------------------------------------------------------;
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;------------------------------------------------------------------------------;
; デフォルト設定
;------------------------------------------------------------------------------;
[Defaults]
command.time        = 15            ; デフォルトコマンド入力時間 (F)
command.buffer.time = 1             ; 先行入力時間 (F)

;------------------------------------------------------------------------------;
; リバティアーツ
;------------------------------------------------------------------------------;
[command]
name        = "濁流斬撃"
command     = ~D, F, b+c
time        = 12
buffer.time = 4

[command]
name        = "濁流斬撃"
command     = ~D, F, y
time        = 12
buffer.time = 4

;------------------------------------------------------------------------------;
; 必殺攻撃
;------------------------------------------------------------------------------;
[command]
name        = "想桜破"
command     = ~D, F, a
time        = 12
buffer.time = 3

[command]
name        = "妖星斬"
command     = ~F, D, DF, b
time        = 15
buffer.time = 3

[command]
name        = "妖星斬"
command     = ~F, D, DF, c
time        = 15
buffer.time = 3

[command]
name        = "清流斬撃"
command     = ~D, B, a
time        = 12
buffer.time = 3

[command]
name        = "清流斬撃"
command     = ~D, B, b
time        = 12
buffer.time = 3

[command]
name        = "清流斬撃"
command     = ~D, B, c
time        = 12
buffer.time = 3

[command]
name        = "残空の太刀"
command     = D, D, a
time        = 18
buffer.time = 3

[command]
name        = "残空の太刀"
command     = D, D, b
time        = 18
buffer.time = 3

[command]
name        = "残空の太刀"
command     = D, D, c
time        = 18
buffer.time = 3

[command]
name        = "踵落し"
command     = b+c
time        = 1
buffer.time = 3

;------------------------------------------------------------------------------;
; システム
;------------------------------------------------------------------------------;
[command]
name    = "longjump"
command = $D, $U
time    = 12

[command]
name    = "Escape"
command = x+a
time    = 1

[command]
name    = "Shield"
command = x+a
time    = 1

[command]
name    = "Guard Cancel"
command = y+b
time    = 1

[command]
name    = "Blocking Upper"
command = F
time    = 1

[command]
name    = "Blocking Lower"
command = D
time    = 1

[command]
name    = "JustDefence Upper"
command = B
time    = 1

[command]
name    = "JustDefence Lower"
command = DB
time    = 1

[command]
name    = "PowerChargeP"
command = /z
time    = 1

[command]
name    = "PowerChargeK"
command = /c
time    = 1

[command]
name    = "Reflect"
command = y
time    = 1

[command]
name    = "Reflect"
command = a+b
time    = 1

;------------------------------------------------------------------------------;
; 基本行動
;------------------------------------------------------------------------------;
[command]               ; ダッシュ (必須)
name    = "FF"
command = F, F
time    = 12

[command]               ; バックステップ (必須)
name    = "BB"
command = B, B
time    = 12

[command]               ; 受身 (必須)
name    = "recovery"
command = x
time    = 1

[command]               ; 受身 (必須)
name    = "recovery"
command = y
time    = 1

[command]               ; 受身 (必須)
name    = "recovery"
command = z
time    = 1

[command]               ; 受身 (必須)
name    = "recovery"
command = a
time    = 1

[command]               ; 受身 (必須)
name    = "recovery"
command = b
time    = 1

[command]               ; 受身 (必須)
name    = "recovery"
command = c
time    = 1

;------------------------------------------------------------------------------;
; ボタン設定
;------------------------------------------------------------------------------;
[command]               ; 必須コマンド
name    = "holdfwd"
command = /$F
time    = 1

[command]               ; 必須コマンド
name    = "holdback"
command = /$B
time    = 1

[command]               ; 必須コマンド
name    = "holdup"
command = /$U
time    = 1

[command]               ; 必須コマンド
name    = "holddown"
command = /$D
time    = 1

[command]
name    = "hold_a"
command = /a
time    = 1

[command]
name    = "hold_b"
command = /b
time    = 1

[command]
name    = "hold_c"
command = /c
time    = 1

[command]
name    = "hold_x"
command = /x
time    = 1

[command]
name    = "hold_y"
command = /y
time    = 1

[command]
name    = "hold_z"
command = /z
time    = 1

[command]
name    = "hold_start"
command = /s
time    = 1

[command]
name    = "fwd"
command = F
time    = 1

[command]
name    = "back"
command = B
time    = 1

[command]
name    = "up"
command = U
time    = 1

[command]
name    = "down"
command = D
time    = 1

[command]
name    = "a"
command = a
time    = 1

[command]
name    = "b"
command = b
time    = 1

[command]
name    = "c"
command = c
time    = 1

[command]
name    = "x"
command = x
time    = 1

[command]
name    = "y"
command = y
time    = 1

[command]
name    = "z"
command = z
time    = 1

[command]
name    = "start"
command = s
time    = 1


;==============================================================================;
;           [ 常時監視ステート -1 (コマンド受付ステート) ]                     ;
;------------------------------------------------------------------------------;
; 1. 時間停止中は条件付きで実行
; 2. ヘルパーも条件付きで参照可能
; 3. 相手にステートを奪われていても有効っぽい
;==============================================================================;
[Statedef -1]

;==============================================================================;
; システム
;==============================================================================;
;------------------------------------------------------------------------------;
; Support Base State No
;------------------------------------------------------------------------------;
[State -1:          Support Base State No (Sierra)]
type       = VarSet
triggerall = IsHelper(20000)
trigger1   = var(59) != 20000
v          = 59
value      = 20000

[State -1:          Support Base State No (Hilda Rize)]
type       = VarSet
triggerall = IsHelper(21000)
trigger1   = var(59) != 21000
v          = 59
value      = 21000

;------------------------------------------------------------------------------;
; サポート行動可能フラグ
;------------------------------------------------------------------------------;
[State -1:          Reset Support CTRL]
type       = VarSet
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = var(0)
trigger1   = Root,StateNo = 150
trigger2   = Root,StateNo = 152
trigger3   = Root,StateNo = 154
trigger4   = StateNo != var(59)
trigger4   = StateNo != var(59) + 10
trigger5   = Root,MoveType = H
trigger6   = !Root,Ctrl
v          = 0
value      = 0

[State -1:          Support CTRL]
type       = VarSet
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = !var(0)
triggerall = (StateNo = var(59) || StateNo = (var(59) + 10))
trigger1   = Root,StateNo = 151         ; Guard Knock back
trigger2   = Root,StateNo = 153
trigger3   = Root,StateNo = 155
trigger4   = Root,Ctrl                  ; Root Ctrl
trigger5   = Root,StateNo = [0, 119]    ; Common States
trigger6   = Root,StateNo = 200         ; Normal Attacks
trigger7   = Root,StateNo = 205
trigger8   = Root,StateNo = 210
trigger9   = Root,StateNo = 220
trigger10  = Root,StateNo = 400
trigger11  = Root,StateNo = 405
trigger12  = Root,StateNo = 410
trigger13  = Root,StateNo = 420
trigger14  = Root,StateNo = [600, 601]
trigger15  = Root,StateNo = 610
trigger16  = Root,StateNo = 620
trigger17  = Root,StateNo = 1000            ; 急降下
trigger18  = Root,StateNo = 1001
trigger19  = Root,StateNo = 1100            ; 踵落し
trigger20  = Root,StateNo = [1400, 1401]    ; 残空の太刀
trigger21  = Root,MoveContact
trigger22  = Root,StateNo = 1500            ; 想桜破
trigger23  = Root,StateNo = 1510
v          = 0
value      = 1

;==============================================================================;
; 基本行動
;==============================================================================;
[State -1:          Dash Forward (Run)]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType = S
triggerall = command = "FF"
trigger1   = ctrl
value      = 100

[State -1:          Back Step]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType = S
triggerall = command = "BB"
trigger1   = ctrl
value      = 105

;==============================================================================;
; システム
;==============================================================================;
;------------------------------------------------------------------------------;
; リフレクト
;------------------------------------------------------------------------------;
[State -1:          Stand Reflect]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "Reflect"
triggerall = command != "holddown"
triggerall = command != "holdfwd"
trigger1   = ctrl
value      = 900

[State -1:          Crouch Reflect]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "Reflect"
triggerall = command = "holddown"
trigger1   = ctrl
value      = 910

[State -1:          Air Reflect]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType = A
triggerall = command = "Reflect"
trigger1   = ctrl
value      = 920

;==============================================================================;
; リバティーアーツ
;==============================================================================;
;------------------------------------------------------------------------------;
; 濁流斬撃
;------------------------------------------------------------------------------;
[State -1:          濁流斬撃]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = Power >= var(1)
triggerall = command = "濁流斬撃"
triggerall = command != "holddown"
trigger1   = ctrl
trigger2   = var(10)
value      = 2000

;==============================================================================;
; 必殺攻撃
;==============================================================================;
;------------------------------------------------------------------------------;
; 妖星斬
;------------------------------------------------------------------------------;
[State -1:          妖星斬]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "妖星斬"
triggerall = command != "holddown"
trigger1   = ctrl
trigger2   = var(10)
value      = ifelse(command = "c", 1301, 1300)

;------------------------------------------------------------------------------;
; 清流斬撃
;------------------------------------------------------------------------------;
[State -1:          清流斬撃]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "清流斬撃"
triggerall = command != "holddown"
trigger1   = ctrl
trigger2   = var(10)
value      = ifelse(command = "c", 1202, ifelse(command = "b", 1201, 1200))

;------------------------------------------------------------------------------;
; 想桜破
;------------------------------------------------------------------------------;
[State -1:          想桜破 (地上)]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "想桜破"
triggerall = command != "holddown"
trigger1   = ctrl
trigger2   = var(10)
value      = 1500

[State -1:          想桜破 (空中)]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType = A
triggerall = command = "想桜破"
trigger1   = ctrl
trigger2   = var(10)
value      = 1510

;------------------------------------------------------------------------------;
; 残空の太刀
;------------------------------------------------------------------------------;
[State -1:          残空の太刀]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "残空の太刀"
trigger1   = ctrl
trigger2   = var(10)
value      = ifelse(command = "c", 1402, ifelse(command = "b", 1401, 1400))

;------------------------------------------------------------------------------;
; 踵落し
;------------------------------------------------------------------------------;
[State -1:          踵落し]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "踵落し" || (command = "holdfwd" && command = "y")
triggerall = command != "holddown"
trigger1   = ctrl
trigger2   = var(10)
value      = 1100

;------------------------------------------------------------------------------;
; 急降下
;------------------------------------------------------------------------------;
[State -1:          急降下]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType = A
triggerall = Vel X >= 0
triggerall = Pos Y < (0 - Abs(const(movement.airjump.height)))
triggerall = command = "holddown" && (command = "b" || command = "c")
trigger1   = ctrl
trigger2   = var(10)            ; 通常技キャンセル
value      = ifelse(command = "c", 1001, 1000)

;==============================================================================;
; 通常攻撃
;==============================================================================;
;------------------------------------------------------------------------------;
; 投げ
;------------------------------------------------------------------------------;
[State -1:          Throw]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType = S
triggerall = P2BodyDist X = [-70 * const(size.xscale), 150 * const(size.xscale)]
triggerall = command = "c"
triggerall = command = "holdfwd" || command = "holdback"
trigger1   = ctrl
value      = 500

;------------------------------------------------------------------------------;
; 通常攻撃 (立ち)
;------------------------------------------------------------------------------;
[State -1:          Stand Hard Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "c"
triggerall = command != "holddown"
trigger1   = ctrl
trigger2   = var(10) = [1, 4]
value      = 220

[State -1:          Stand Middle Attack, 2]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "b" && command = "holdfwd"
triggerall = command != "holddown"
trigger1   = ctrl
trigger2   = var(10) = [1, 3]
value      = 215

[State -1:          Stand Middle Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "b"
triggerall = command != "holddown"
trigger1   = ctrl
trigger2   = var(10) = [1, 2]
value      = 210

[State -1:          Stand Light Attack, 2]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "a" && command = "holdfwd"
triggerall = command != "holddown"
trigger1   = ctrl
trigger2   = var(10) = 1
value      = 205

[State -1:          Stand Light Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "a"
triggerall = command != "holddown"
trigger1   = ctrl
trigger2   = var(10) = 1
value      = 200

;------------------------------------------------------------------------------;
; 通常攻撃 (しゃがみ)
;------------------------------------------------------------------------------;
[State -1:          Crouch Hard Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "c"
triggerall = command = "holddown"
trigger1   = ctrl
trigger2   = var(10) = [1, 4]
value      = 420

[State -1:          Crouch Middel Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "b"
triggerall = command = "holddown"
trigger1   = ctrl
trigger2   = var(10) = [1, 2]
value      = 410

[State -1:          Crouch Light Attack, 2]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "a" && command = "holdfwd"
triggerall = command = "holddown"
trigger1   = ctrl
trigger2   = var(10) = 1
value      = 405

[State -1:          Crouch Light Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType != A
triggerall = command = "a"
triggerall = command = "holddown"
trigger1   = ctrl
trigger2   = var(10) = 1
value      = 400

;------------------------------------------------------------------------------;
; 通常攻撃 (空中)
;------------------------------------------------------------------------------;
[State -1:          Air Hard Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType = A
triggerall = command = "c"
trigger1   = ctrl
trigger2   = var(10) = [1, 4]
value      = 620

[State -1:          Air Middle Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType = A
triggerall = command = "b"
trigger1   = ctrl
trigger2   = var(10) = [1, 2]
value      = 610

[State -1:          Air Light Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = !var(59)
triggerall = StateType = A
triggerall = command = "a"
trigger1   = ctrl
trigger2   = var(10) = 1
value      = 600

;==============================================================================;
; サポート行動
;==============================================================================;
[State -1:          Support Attack, 3]
type       = ChangeState
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = RoundState = 2
triggerall = Root,var(59) = 0
triggerall = Root,var(25) >= 200
triggerall = command = "x" && command = "holddown"
triggerall = ifelse((Root,Facing != Facing), command = "holdback", command = "holdfwd")
trigger1   = var(0)         ; 擬似CTRL
value      = var(59) + 220

[State -1:          Support Attack, 4]
type       = ChangeState
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = RoundState = 2
triggerall = Root,var(59) = 0
triggerall = Root,var(25) >= 200
triggerall = command = "x" && command = "holddown"
trigger1   = var(0)         ; 擬似CTRL
value      = var(59) + 230

[State -1:          Support Attack, 2]
type       = ChangeState
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = RoundState = 2
triggerall = Root,var(59) = 0
triggerall = Root,var(25) >= 100
triggerall = command = "x"
triggerall = ifelse((Root,Facing != Facing), command = "holdback", command = "holdfwd")
trigger1   = var(0)         ; 擬似CTRL
value      = var(59) + 210

[State -1:          Support Proxy Guard]
type       = ChangeState
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = RoundState = 2
triggerall = Root,var(59) = 0
triggerall = Root,var(25) >= 100
triggerall = command = "x"
triggerall = ifelse((Root,Facing != Facing), command = "holdfwd", command = "holdback")
trigger1   = var(0)         ; 擬似CTRL
value      = var(59) + 300

[State -1:          Support Attack, 1]
type       = ChangeState
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = RoundState = 2
triggerall = Root,var(59) = 0
triggerall = Root,var(25) >= 100
triggerall = command = "x"
trigger1   = var(0)         ; 擬似CTRL
value      = var(59) + 200


;==============================================================================;
; サポート行動
;==============================================================================;

;しえら

[State -1:          AI Support Attack, 3]
type       = ChangeState
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = RoundState = 2 && Root,Alive
triggerall = PlayerIDExist(Root,var(35))
triggerall = Root,var(59) != 0
triggerall = Root,var(25) > 200
triggerall=(P2bodydist y>-20)||(backedgebodydist<20)
triggerall=((p2bodydist x=[10,70])&&(PlayerID(Root,var(35)),Vel X<=0)) ||((p2bodydist x =[50,160])&&(PlayerID(Root,var(35)),Vel X >0))||(backedgebodydist<20)
triggerall=Root,var(54)=1
triggerall=var(56)=0
triggerall=(random>var(50)*950)||(backedgebodydist<20)
trigger1=(p2bodydist x =[10,40])
trigger1=p2statetype!=L
trigger1= var(0)
trigger1=random<50
trigger2=(frontEdgebodyDist)-(p2bodydist x)<50
trigger2= var(0)
trigger2=random<50
trigger2=(p2bodydist x =[10,40])
;trigger4=p2statetype=L
;trigger4=var(56)=0
;trigger5=statetype=L
trigger3= var(0)
trigger3=(backedgebodydist<30)
trigger3=p2bodydist x =[0,100]
trigger3=(p2statetype!=L)&&(p2movetype!=H)
trigger4= var(0)
trigger4=random<100
trigger4=p2StateNo = [5100,5199]
trigger4=(p2bodydist x =[10,30])
value      = var(59) + 220

[State -1:          AI Support Attack, 2];;;;;;;;;;;;;;;;
type       = ChangeState
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = RoundState = 2 && Root,Alive
triggerall = PlayerIDExist(Root,var(35))
triggerall = Root,var(59) != 0
triggerall = Root,var(25) > 100
triggerall=(statetype !=L) &&(movetype !=H) 
triggerall=Root,var(54)=1
triggerall=((p2bodydist x =[50,300])&&(PlayerID(Root,var(35)),Vel X<=0)) ||((p2bodydist x =[50,300])&&(PlayerID(Root,var(35)),Vel X >0))||((frontEdgebodyDist)-(p2bodydist x)<30)
triggerall=var(56)=0
triggerall=random>var(50)*970
trigger1 = RoundState = 2
trigger1   = var(0)         ; 擬似CTRL
trigger1   = ((p2bodydist x >100)&&(random<100))||(Random < 10 + (PlayerID(Root,var(35)),StateType != A) * 40)||((P2statetype=L)&&(random<100))
value      = var(59) + 210


[State -1:          Support Attack, 1]
type       = ChangeState
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = RoundState = 2 && Root,Alive
triggerall = PlayerIDExist(Root,var(35))
triggerall = P2StateType != L
triggerall = Root,var(59) != 0
triggerall = Root,var(25) > 100
triggerall=(PlayerID(Root,var(35)),pos x - Helper(20000),pos x =[-50,50]) 
triggerall=(statetype !=L) &&(StateNo != [5000,5059]) 
triggerall=Root,var(54)=1
triggerall=p2bodydist y >=0 
triggerall=var(56)=0
triggerall=p2bodydist x<140
triggerall=(random>var(50)*970)||(backedgebodydist<20)
trigger1   = var(0)         ; 擬似CTRL
trigger1   = (Random < 15 + (PlayerID(Root,var(35)),HitFall)* 35)||((statetype!=L)&&(movetype!=H))
trigger2=p2stateno=5199
trigger2   = var(0)  
value     = var(59) + 200


[State -1:          AI Support Attack, 4]
type       = ChangeState
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = RoundState = 2 && Root,Alive
triggerall = PlayerIDExist(Root,var(35))
triggerall = Root,var(59) != 0
triggerall = Root,var(25) > 200;260;225
;triggerall=(enemynear(0),pos x - Helper(20000),pos x =[-60,60]) ||(enemynear(0),pos x - Helper(21000),pos x =[-60,60])
triggerall=Root,var(54)=1
;trigger1   = var(0)         ; 擬似CTRL
;trigger1=var(56)=1
;trigger1   = Random < 5 + (PlayerID(Root,var(35)),StateType = L) * 20 + (PlayerID(Root,var(35)),HitFall) * 20
trigger1   = var(0)         ; 擬似CTRL
trigger1=var(56)=0
;trigger2   = Random < 20;5 + (PlayerID(Root,var(35)),StateType = L) * 20 + (PlayerID(Root,var(35)),HitFall) * 20
;trigger1=P2BodyDist X = [-100,100]
trigger1=p2statetype!=L
trigger1=StateNo != [5000,5059]
trigger1 = Root,var(25) = 500
;trigger2=(StateNo =[1300,1301])||(prevStateNo =[1300,1301]) 
;trigger2=movehit
;trigger1=p2statetype!=A ;&& p2bodydist y >-70
;trigger1=(StateNo != [5000,5059]) && (statetype !=L) &&(movetype !=H) 
;trigger1=var(56)=0
;trigger1=(random<0);||((Root,var(25) > 400)&&(movetype!=H))
value      = var(59) + 230




;ヒルダ(デフォ)

[State -1:          AI Support Attack, 3]
type       = ChangeState
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = RoundState = 2 && Root,Alive
triggerall = PlayerIDExist(Root,var(35))
triggerall = Root,var(59) != 0
triggerall = Root,var(25) >= 200
triggerall=var(56)=1
trigger1   = var(0)         ; 擬似CTRL
trigger1   = Abs(PlayerID(Root,var(35)),Pos X - Pos X) < (300 * const(size.xscale))
trigger1   = Random < 20 + (PlayerID(Root,var(35)),MoveType = A) * 10
value      = var(59) + 220

[State -1:          AI Support Attack, 4]
type       = ChangeState
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = RoundState = 2 && Root,Alive
triggerall = PlayerIDExist(Root,var(35))
triggerall = Root,var(59) != 0
triggerall = Root,var(25) >= 200
triggerall=var(56)=1
trigger1   = var(0)         ; 擬似CTRL
trigger1   = Random < 5 + (PlayerID(Root,var(35)),StateType = L) * 20 + (PlayerID(Root,var(35)),HitFall) * 20
value      = var(59) + 230

[State -1:          AI Support Attack, 2]
type       = ChangeState
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = RoundState = 2 && Root,Alive
triggerall = PlayerIDExist(Root,var(35))
triggerall = Root,var(59) != 0
triggerall = Root,var(25) >= 100
triggerall=var(56)=1
trigger1   = var(0)         ; 擬似CTRL
trigger1   = Abs(PlayerID(Root,var(35)),Pos X - Pos X) = [100 * const(size.xscale), 400 * const(size.xscale)]
trigger1   = Random < 15 + (PlayerID(Root,var(35)),StateType != A) * 15
value      = var(59) + 210

[State -1:          AI Support Proxy Guard]
type       = ChangeState
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = RoundState = 2 && Root,Alive
triggerall = PlayerIDExist(Root,var(35))
triggerall = Root,var(59) != 0
triggerall = Root,var(25) >= 100
triggerall=var(56)=1
trigger1   = var(0)         ; 擬似CTRL
trigger1   = (PlayerID(Root,var(35)),NumProj > 0)
trigger1   = Random < 95 + (PlayerID(Root,var(35)),NumProj) * 10
value      = var(59) + 300

[State -1:          Support Attack, 1]
type       = ChangeState
triggerall = IsHelper(20000) || IsHelper(21000)
triggerall = RoundState = 2 && Root,Alive
triggerall = PlayerIDExist(Root,var(35))
triggerall = Root,var(59) != 0
triggerall = Root,var(25) >= 100
triggerall=var(56)=1
trigger1   = var(0)         ; 擬似CTRL
trigger1   = Abs(PlayerID(Root,var(35)),Pos X - Pos X) < (200 * const(size.xscale))
trigger1   = Random < 15 + (PlayerID(Root,var(35)),HitFall) * 15
value      = var(59) + 200



[State -1:          AI Crouch Light Attack, 2]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = PlayerID(var(35)),StateType != C
;triggerall = P2BodyDist X = [0 * const(size.xscale), (155 * const(size.xscale)-5)]
;triggerall = P2BodyDist Y = [-310 * const(size.yscale), 0 * const(size.yscale)]
trigger1=(prevstateno=900)&&(P2statetype=A)
value      = 405

[State -1:          AI Crouch Light Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = P2BodyDist X = [-10,5];[0 * const(size.xscale), 105 * const(size.xscale)]
triggerall = P2statetype !=A;[-140 * const(size.yscale), 0 * const(size.yscale)]
trigger1=(prevstateno=910)
;trigger4=InGuardDist=0
value      = 400
[State -1:          AI Stand Light Attack, 2]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = P2BodyDist X = [0,40];[0 * const(size.xscale), 165 * const(size.xscale)]
triggerall = P2statetype !=A;P2BodyDist Y = [-200 * const(size.yscale), 0 * const(size.yscale)]
trigger1=(prevstateno=900)&&(P2BodyDist X=[20,40])
;Trigger4 = ctrl
;trigger4=InGuardDist=0
value      = 205


[State -1:          AI Stand Light Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = P2BodyDist X = [-20,20];[0 * const(size.xscale), 120 * const(size.xscale)]
triggerall = P2statetype !=A ;[-150 * const(size.yscale), 80 * const(size.yscale)]
trigger1=(prevstateno=900)&&(P2BodyDist X<=30)
value      = 200

[State -1:          AI 濁流斬撃]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = Power >= var(1)
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = P2BodyDist X-(PlayerID(var(35)),Vel X*10) = [-5,200]
triggerall=P2BodyDist Y+(PlayerID(var(35)),Vel Y*7) = [-10,15];((P2BodyDist Y>=0)&&(PlayerID(var(35)),Vel Y<0))||((P2BodyDist Y=[-40,-20])&&(PlayerID(var(35)),Vel Y>0))||((P2BodyDist Y=[-40,0])&&(PlayerID(var(35)),Vel Y=0));(P2BodyDist Y+(PlayerID(Root,var(35)),Vel Y*15) = [0,20])
Triggerall = p2stateno != [120,159]
triggerall=p2bodydist x >-5
triggerall=var(52)=1 
trigger1=(prevstateno=900)&&(P2movetype=A)
Value      = 2000

[State -1:          AI 踵落し];;;;;;;;;
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = P2BodyDist X = [0,50];[0 * const(size.xscale), 200 * const(size.xscale)]
triggerall = P2BodyDist Y = [-310 * const(size.yscale), 100 * const(size.yscale)]
triggerall=(stateno!=2000)
triggerall = (PlayerID(var(35)),moveType !=A) ||(PlayerID(var(35)),StateType = C)
trigger1= PrevStateNo =200
Trigger1 = MoveGuarded
trigger2= PrevStateNo =[410,420]
trigger2= PlayerID(var(35)),movetype=H
value      = 1100
;==============================================================================;
; リバティーアーツ
;==============================================================================;
;------------------------------------------------------------------------------;
; 濁流斬撃
;------------------------------------------------------------------------------;
[State -1:          AI 濁流斬撃]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = Power >= var(1)
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = P2BodyDist X-(PlayerID(var(35)),Vel X*10) = [-5,200]
triggerall=P2BodyDist Y+(PlayerID(var(35)),Vel Y*7) = [-10,15];((P2BodyDist Y>=0)&&(PlayerID(var(35)),Vel Y<0))||((P2BodyDist Y=[-40,-20])&&(PlayerID(var(35)),Vel Y>0))||((P2BodyDist Y=[-40,0])&&(PlayerID(var(35)),Vel Y=0));(P2BodyDist Y+(PlayerID(Root,var(35)),Vel Y*15) = [0,20])
triggerall = fvar(30) = [-70, 70]
Triggerall = p2stateno != [120,159]
triggerall=p2bodydist x >-5
triggerall=((PlayerID(var(35)),numproj <= 0) &&(PlayerID(var(35)),NumHelper <=Var(51)))||(P2BodyDist X<=50)
triggerall=(prevstateno!=2000);||(MoveContact>=1)
trigger1   = (p2StateNo = [5000,5059])
trigger1   = ctrl
trigger2   = var(10)
trigger2   = (p2StateNo = [5000,5059])
;trigger3= ( P2BodyDist X-(PlayerID(var(35)),Vel X
;trigger3=((PlayerID(var(35)),numproj <= 0) &&(PlayerID(var(35)),NumHelper <=Var(51)))
trigger3=(P2moveType =A) &&(p2StateNo !=5210)
trigger3=((P2BodyDist X=[50,200])&&(InGuardDist=0));||(P2BodyDist X=[-10,20])
;Trigger3 = (PlayerID(var(35)),NumHelper <=Var(51));||(P2moveType !=A)
trigger3=ctrl
trigger4=(p2statetype=A)&&(p2StateNo != [5000,5059])
trigger4=(P2moveType !=A)
trigger4=(PlayerID(var(35)),Vel X<0)||(PlayerID(var(35)),Vel y>=0)
;trigger4= ((P2BodyDist Y>=0)
trigger4=ctrl
trigger5=prevstateno=[1300,1302]
trigger5=movehit
trigger6=((PlayerID(var(35)),facing=-1)&&(facing=-1))||((PlayerID(var(35)),facing=1)&&(facing=1))
trigger6=p2stateno != [120,159]
;trigger6=PlayerID(var(35)),movetype!=I
trigger6=ctrl
;trigger7=(prevstateno=900)&&(P2BodyDist X>30)&&CTRL
trigger7=(prevstateno=210)&&(movehit)&&(p2StateNo = [5000,5059])&&CTRL
value      = 2000
;==============================================================================;
; 基本行動
;==============================================================================;
[State -1:          AI 妖星斬]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = P2StateType != C
triggerall = PlayerIDExist(var(35))
triggerall = (P2BodyDist X-(PlayerID(var(35)),Vel X*12)=[-100,40])&&(P2BodyDist X>=0);||(P2BodyDist X=[-10,100])&&((PlayerID(var(35)),Vel X>0)||
;triggerall =(P2BodyDist Y=[-150,100])||(P2BodyDist X=[-10,20])
triggerall=P2BodyDist X>-20
triggerall=prevstateno !=[1300,1301]
triggerall = fvar(30) = [-100, 0]
;triggerall=InGuardDist=0
triggerall=PlayerID(var(35)),movetype !=A
trigger1=p2statetype=A
trigger1=ctrl
;trigger2=((prevstateno=900)||(PREVStateNo = [5120,5149]))&&(((P2BodyDist X=[-10,10])||(p2statetype=A))&&(P2BodyDist X=[-10,45]))
value=ifelse(((P2BodyDist X>5)&&(P2BodyDist Y>0)),1300,1301);1301

[State -1:          AI Crouch Light Attack, 2]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = P2StateType != C
triggerall = PlayerIDExist(var(35))
triggerall = (P2BodyDist X-(PlayerID(var(35)),Vel X*12)=[0,40])&&(P2BodyDist X>=0);||(P2BodyDist X=[-10,100])&&((PlayerID(var(35)),Vel X>0)||
triggerall =(P2BodyDist Y=[-100,-50]);||(P2BodyDist X=[-10,20])
triggerall = PlayerID(var(35)),Vel y>=0
;triggerall=P2BodyDist X>-20
triggerall=prevstateno !=[1300,1301]
;triggerall = fvar(30) = [-100, 0]
;triggerall=InGuardDist=0
triggerall=PlayerID(var(35)),movetype =A
triggerall=((PlayerID(var(35)),numproj <= 0) &&(PlayerID(var(35)),NumHelper <=Var(51)))
trigger1=p2statetype=A
trigger1=ctrl
value      = 405
;------------------------------------------------------------------------------;
; ガード
;------------------------------------------------------------------------------;
[State -1:          AI Guarding]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateNo != [120, 159]
triggerall = (InGuardDist);&&((PlayerID(var(35)),MoveType = A) || (PlayerID(Root,var(35)),numproj > 0) || (PlayerID(Root,var(35)),NumHelper >0))
triggerall = ctrl
;;triggerALL=var(52)=0
;trigger1   =(random<990-100*Var(57)); (PlayerID(Root,var(35)),numproj > 0) || (PlayerID(Root,var(35)),NumHelper >0);(IsHelper);135
;trigger1   =(PlayerID(var(35)),HitDefAttr=SCA,NA,SA,HA);&&(InGuardDist)
;trigger1   =(InGuardDist)
trigger1=(PlayerID(var(35)),numproj > 0) || (PlayerID(var(35)),NumHelper >Var(51))
;;trigger2=var(52)=0
trigger1=random<999
trigger1=(InGuardDist)
;trigger2=prevstateno=[5120,5199]
;trigger2=p2bodydist X=[-50,50]
;trigger2=random<999
value      = 120
[State -1:          AI Guarding]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateNo != 900
triggerall = StateNo != 130
triggerall = (InGuardDist);&&((PlayerID(var(35)),MoveType = A) || (PlayerID(Root,var(35)),numproj > 0) || (PlayerID(Root,var(35)),NumHelper >0))
triggerall   =StateType !=A
triggerall = ctrl
trigger1 =((PlayerID(var(35)),numproj <= 0) && (PlayerID(var(35)),NumHelper <=Var(51)))
;triggerALL=var(52)=0
;trigger1   =random>990-100*Var(57); (PlayerID(Root,var(35)),numproj > 0) || (PlayerID(Root,var(35)),NumHelper >0);(IsHelper);135
trigger1   =(PlayerID(var(35)),HitDefAttr=SCA,NA,SA,HA);&&(InGuardDist)
trigger1   =(InGuardDist)
trigger1   =(PlayerID(var(35)),StateType=S) || (PlayerID(var(35)),StateType=A)
;trigger2=prevstateno=[5120,5199]
;trigger2=p2bodydist X=[-50,50]
;trigger2=random<999
value      =ifelse((random<990-100*Var(57)),130,900); 900
[State -1:          AI Guarding]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateNo != 910
triggerall = StateNo != 131
triggerall = (InGuardDist);&&((PlayerID(var(35)),MoveType = A) || (PlayerID(Root,var(35)),numproj > 0) || (PlayerID(Root,var(35)),NumHelper >0))
triggerall   =StateType !=A
triggerall = ctrl
trigger1 =((PlayerID(var(35)),numproj <= 0) && (PlayerID(var(35)),NumHelper <=Var(51)))
;triggerALL=var(52)=0
;trigger1   =random>990-100*Var(57); (PlayerID(Root,var(35)),numproj > 0) || (PlayerID(Root,var(35)),NumHelper >0);(IsHelper);135
trigger1   =(PlayerID(var(35)),HitDefAttr=SCA,NA,SA,HA);&&(InGuardDist)
trigger1   =(InGuardDist)
trigger1   =(PlayerID(var(35)),StateType=S) ||(PlayerID(var(35)),StateType=C)
;trigger2=prevstateno=[5120,5199]
;trigger2=p2bodydist X=[-50,50]
;trigger2=random<999
value      = ifelse((random<990-100*Var(57)),131,910);910
[State -1:          AI Guarding]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateNo != 920
triggerall = StateNo != 132
triggerall = (InGuardDist);&&((PlayerID(var(35)),MoveType = A) || (PlayerID(Root,var(35)),numproj > 0) || (PlayerID(Root,var(35)),NumHelper >0))
triggerALL   =StateType=A
triggerall = ctrl
trigger1 =((PlayerID(var(35)),numproj <= 0) && (PlayerID(var(35)),NumHelper <=Var(51)))
;triggerALL=var(52)=0
;trigger1   =random>990-100*Var(57); (PlayerID(Root,var(35)),numproj > 0) || (PlayerID(Root,var(35)),NumHelper >0);(IsHelper);135
trigger1   =(PlayerID(var(35)),HitDefAttr=SCA,NA,SA,HA);&&(InGuardDist)
trigger1   =(InGuardDist)
value      = ifelse((random<990-100*Var(57)),132,920);920




[State -1:          AI Dash Forward (Run)]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType = S
triggerall = PlayerIDExist(var(35))
triggerall = StateNo != 100
triggerall=p2bodydist x >100
triggerall=((p2stateno = [120,159])||(p2StateNo = [5000,5059])) || ( p2bodydist x >100)||(p2statetype=L)
triggerall = ctrl
trigger1   = FrontEdgeDist > (100 * fvar(31))
trigger1   = PlayerID(var(35)),StateType = A
trigger1   = PlayerID(var(35)),HitFall = 1
trigger1   = ifelse((Facing != PlayerID(var(35)),Facing), PlayerID(var(35)),Vel X < (-5 * fvar(31)), PlayerID(var(35)),Vel X > (5 * fvar(31)))
trigger1   = !InGuardDist
trigger1   = Random < 125
trigger2   = !InGuardDist
trigger2   = Abs(PlayerID(var(35)),Pos X - Pos X) > (160 * fvar(31))
trigger2   = Random < 95
trigger3   = !InGuardDist
trigger3=((p2stateno = [120,159])||(p2StateNo = [5000,5059])) && ( p2bodydist x >30)
value      = 100
[State -1:          AI Dash Forward (Run)]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType = S
triggerall = PlayerIDExist(var(35))
triggerall = ctrl
triggerall = StateNo != 100
triggerall = !InGuardDist
triggerall=p2statetype!=L
trigger1=p2bodydist x =[60,200]
trigger1=stateno=[(var(59) + 210),(var(59) + 220)]
trigger2=p2bodydist x =[20,60]
trigger2=stateno=[(var(59) + 210),(var(59) + 220)]
trigger2=p2stateno = [120,159]
trigger3=stateno=[1500,1510]
trigger3=p2bodydist x >40
trigger4=stateno=[1500,1510]
trigger4=p2stateno = [120,159]
trigger4=p2bodydist x >20
value      = 100

[State -1:          AI Back Step]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType = S
triggerall = PlayerIDExist(var(35))
triggerall=backedgebodydist>30
triggerall !=((stateno=[(var(59) + 210),(var(59) + 220)])&&(p2stateno = [120,159]))
triggerall = ctrl
trigger1   = BackEdgeDist < (100 * fvar(31))
trigger1   = PlayerID(var(35)),StateType = L
trigger1   = Abs(Pos X - PlayerID(var(35)),Pos X) < (60 * fvar(31))
trigger1   = Random < 85
trigger2 = Root,var(25) < 205
trigger2=p2bodydist x =[40,60]
trigger2=p2statetype=L
trigger3=p2bodydist x =[50,100] 
trigger3=(p2movetype !=H) && (p2movetype !=A)
trigger3=random<100
trigger4=(p2movetype !=H) && (p2movetype !=A)
trigger4=stateno=[(var(59) + 210),(var(59) + 220)]
trigger4=p2stateno != [120,159]
trigger4=p2bodydist x <100
trigger5=prevstateno=900
trigger5=random<100
trigger6=random<200
trigger6=p2bodydist x<50
trigger6=(p2movetype !=H) && (p2movetype !=A)
trigger7=p2bodydist x=[-10,45]
trigger7=p2StateNo = [5100,5199] 
trigger7=time=[19,20]
trigger7=ctrl
TRIGGER7=RANDOM=[300,400]
trigger8=p2bodydist x<20
trigger8=p2Statetype =L ;(p2StateNo =5120 )&&(time=1)&&(p2Statetype =L )
trigger8=ctrl
;trigger8=random=[500,700]
value      = 105








[State -1:          AI 踵落し];;;;;;;;;
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = PlayerIDExist(var(35))
;triggerall = P2BodyDist X = [-10,50];[0 * const(size.xscale), 200 * const(size.xscale)]
;triggerall = P2BodyDist Y = [-310 * const(size.yscale), 100 * const(size.yscale)]
;trigger1=stateno=[(var(59) + 210),(var(59) + 220)]
;triggerall=var(51)>0
trigger1=random<500
trigger1=p2bodydist x=[-10,45]
trigger1=(p2StateNo =5120 )&&(time=2)&&(p2Statetype =L )||(p2StateNo =[5121,5199]);(p2StateNo =[5100,5199] )&&(time=abs(var(51)-15))
;trigger1=time=abs(var(51)-);18;[19,20]
trigger1=ctrl
;trigger1=stateno=[(var(59) + 210),(var(59) + 220)]
;TRIGGER1=RANDOM<200
trigger2=p2bodydist x=[-10,55]
trigger2=((p2StateNo =5120 )&&(time=2)&&(p2Statetype =L ))||(p2StateNo =[5121,5199]);(p2StateNo =[5100,5199] )&&(time=abs(var(51)-15))
;trigger1=time=abs(var(51)-10);18;[19,20]
trigger2=(stateno=100)||(stateno=21)
value      = 1100

[State -1:          AI 残空の太刀]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall=(P2BodyDist X =[130,132])|| (( (frontEdgebodyDist)-(p2bodydist x)<20)&&(P2BodyDist x =[80,140]))
;triggerall=var(51)>0
;trigger1=stateno=[(var(59) + 210),(var(59) + 220)]
trigger1=(p2StateNo =5120 );&&(time=abs(var(51)-30))
trigger1=random=[200,300]
trigger1=ctrl
;trigger1=time=abs(var(51)-15);9;[20,24]
;trigger6=( (frontEdgebodyDist)-(p2bodydist x)<30)&&(P2BodyDist x <30)
trigger2=(p2StateNo =5120 );(p2StateNo =[5100,5199] )&&(time=abs(var(51)-15))
;trigger1=time=abs(var(51)-10);18;[19,20]
trigger2=stateno=100
value      = 1402

[State -1:          AI 残空の太刀]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall=(P2BodyDist x = [75,77]) || (( (frontEdgebodyDist)-(p2bodydist x)<20)&&(P2BodyDist x =[10,80]))
;triggerall=var(51)>0
;trigger1=stateno=[(var(59) + 210),(var(59) + 20)]
trigger1=(p2StateNo =5120 );&&(time=abs(var(51)-30))
trigger1=ctrl
;trigger4=( (frontEdgebodyDist)-(p2bodydist x)<50)&&(P2BodyDist x <30)
;trigger1=time=abs(var(51)-20);9;[20,24]
trigger2=(p2StateNo =5120 );(p2StateNo =[5100,5199] )&&(time=abs(var(51)-15))
;trigger1=time=abs(var(51)-10);18;[19,20]
trigger2=stateno=100
value      = 1401

;------------------------------------------------------------------------------;
; 想桜破
;------------------------------------------------------------------------------;
[State -1:          AI 想桜破]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
;triggerall = NumHelper(7020)
triggerall = Helper(7020),StateNo = 7020
triggerall = (P2BodyDist X =[0,200])|| ((prevstateno=220)&&(p2StateNo != [5000,5059]))
;triggerall=InGuardDist=0
triggerall=p2StateNo != [120, 159]
triggerall = (P2BodyDist X >100)|| (P2BodyDist Y >=0)||(PlayerID(var(35)),Vel y>=0)
trigger1   = Random < 10 + NumHelper(7020) * 15
trigger1   = ctrl
trigger2   = var(10)
trigger2   = Random < 10 + NumHelper(7020) * 15
trigger3   = Random <  NumHelper(7020) * 400
trigger3   = ctrl
trigger3=(P2BodyDist X =[0,80])&&(p2StateNo != [5000,5059])
trigger4   = var(10)
;trigger4   = Random <  NumHelper(7020) * 500
trigger4=(P2BodyDist X =[0,80])&&(p2StateNo != [5000,5059])
;trigger5   = Random <  NumHelper(7020) * 500
trigger5=(stateno=100)&&(stateno=21)
trigger5=(P2BodyDist X =[0,80])&&(p2StateNo != [5000,5059])
TRIGGER6=(P2BodyDist X>100)&&(p2StateNo != [5000,5059])
trigger6=(PlayerID(var(35)),numproj > 0) || (PlayerID(var(35)),NumHelper >Var(51))
trigger6   = ctrl
value      = ifelse(StateType != A, 1500, 1510)

;------------------------------------------------------------------------------;
; 踵落し
;------------------------------------------------------------------------------;

[State -1:          AI 踵落し];;;;;;;;;
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = P2BodyDist X = [-5,50];[0 * const(size.xscale), 200 * const(size.xscale)]
triggerall = P2BodyDist Y = [-310 * const(size.yscale), 100 * const(size.yscale)]
triggerall=(stateno!=2000)
triggerall = (PlayerID(var(35)),moveType !=A) ||(PlayerID(var(35)),StateType = C)
trigger1=(p2bodydist x <45)  || (p2StateNo = [5000,5059]) 
trigger1   = Random < 5 + (PlayerID(var(35)),StateType = C) * 500;30
trigger1   = ctrl
trigger2=(p2bodydist x >40)  || (p2StateNo = [5000,5059])||((PlayerID(var(35)),StateType = C)&&(p2bodydist x <45))
trigger2   = var(10)
trigger2   = Random < 5 * var(10)
trigger3= PrevStateNo =200
Trigger3 = MoveGuarded
trigger4= PrevStateNo =[410,420]
trigger4= PlayerID(var(35)),moveType =H
;trigger5=ctrl 
;Trigger5 =p2stateno = [120,159]
;trigger5 = p2StateType = C
;trigger5=p2bodydist x<40
;trigger5=(random<50);||((random<200)&&(stateno=[(var(59) + 210),(var(59) + 220)]))
trigger5=(stateno=100)||(stateno=21)
trigger5=(p2bodydist x<45);||((p2bodydist x<60 )&& (PlayerID(var(35)),Vel X>0))
trigger5=(random<100)||(PlayerID(var(35)),stateno = [120,159])
trigger5=p2statetype=C
value      = 1100

;==============================================================================;
; 通常攻撃
;==============================================================================;

;------------------------------------------------------------------------------;
; 通常攻撃 (しゃがみ)
;------------------------------------------------------------------------------;
[State -1:          AI Crouch Hard Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = PlayerID(var(35)),StateType != A
triggerall = PlayerID(var(35)),Stateno !=39
triggerall = (P2BodyDist X = [5,55])||(P2BodyDist X=[60,75])&&((PlayerID(var(35)),Vel X>0));||stateno=100||((p2stateno = [120,159])&&(P2BodyDist X = [0,55])&&(p2StateType = S));[0 * const(size.xscale), 190 * const(size.xscale)]
triggerall=random=[0,500]
triggerall=InGuardDist=0
triggerall = PlayerID(var(35)),moveType !=A
trigger1 = (P2BodyDist X = [45,55])||(P2BodyDist X=[60,75])&&((PlayerID(var(35)),Vel X>0))
trigger1   = Random < 25 + (PlayerID(var(35)),StateType = S) * 70;20
trigger1   = ctrl
trigger2 = (P2BodyDist X = [45,55])||(P2BodyDist X=[60,75])&&((PlayerID(var(35)),Vel X>0))
trigger2   = var(10) = [1, 4]
trigger2   = Random < 15 * var(10)
trigger3 = (P2BodyDist X = [45,55])||(P2BodyDist X=[60,75])&&((PlayerID(var(35)),Vel X>0))
;trigger3=(stateno=var(59) + 210)||( var(59) + 220)
Trigger3 =p2stateno = [120,159]
trigger3 = p2StateType = S
trigger3=ctrl 
trigger4=(stateno=100)||(stateno=21)
trigger4=(p2bodydist x<50)||((p2bodydist x<60 )&& (PlayerID(var(35)),Vel X>0))||(p2stateno = [120,159])
trigger4=random<300
trigger4=p2statetype=S
value      = 420

[State -1:          AI Crouch Middel Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = PlayerID(var(35)),StateType != A
triggerall = (P2BodyDist X = [25,30])||((p2stateno = [120,159])&&(P2BodyDist X = [0,30])&&(p2StateType = S))||(P2BodyDist X=[50,60])&&((PlayerID(var(35)),Vel X>0));[0 * const(size.xscale), 115 * const(size.xscale)]
triggerall=random=[0,500]
triggerall=InGuardDist=0
triggerall = PlayerID(var(35)),moveType !=A
trigger1   = Random < 25 + (PlayerID(var(35)),StateType = S) * 70;15
trigger1   = ctrl
trigger2   = (var(10) = [1, 2])&&((PlayerID(var(35)),StateType = S)||(p2StateNo = [5000,5059]))
trigger2   = Random < 20 * var(10)
trigger3=(stateno=var(59) + 210)||( var(59) + 220)
Trigger3 =p2stateno = [120,159]
trigger3 = p2StateType = S
trigger3=ctrl 
value      = 410

[State -1:          AI Crouch Light Attack, 2]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = PlayerID(var(35)),StateType != C
triggerall = P2BodyDist X = [0 * const(size.xscale), (155 * const(size.xscale)-5)]
triggerall = P2BodyDist Y = [-310 * const(size.yscale), 0 * const(size.yscale)]
triggerall = fvar(30) = [-80, 30]
triggerall=random=[0,500]
triggerall = PlayerID(var(35)),moveType !=A
trigger1   = Random < 25 + (PlayerID(var(35)),Vel Y) * 5 - (PlayerID(var(35)),Pos Y)
trigger1   = ctrl
trigger2   = var(10) = 1
trigger2   = Random < 10
value      = 405

[State -1:          AI Crouch Light Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = P2BodyDist X = [-10,5];[0 * const(size.xscale), 105 * const(size.xscale)]
triggerall = P2statetype !=A;[-140 * const(size.yscale), 0 * const(size.yscale)]
triggerall = fvar(30) = [-80, 40]
triggerall=random=[0,500]
triggerall = PlayerID(var(35)),moveType !=A
trigger1   = (Random < 15 + (PlayerID(var(35)),Vel Y) * 100)
trigger1   = ctrl
trigger2   = var(10) = 1
trigger2   = Random < 15
Trigger3 = PREVStateNo = [5120,5149]
trigger3=p2bodydist x=[0,5]
trigger3=random<500
trigger4=(prevstateno=910)
trigger4=InGuardDist=0
Trigger4 = ctrl
value      = 400

;------------------------------------------------------------------------------;
; 通常攻撃 (立ち)
;------------------------------------------------------------------------------;
[State -1:          AI Stand Light Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = P2BodyDist X = [-20,20];[0 * const(size.xscale), 120 * const(size.xscale)]
triggerall = P2BodyDist Y >=0 ;[-150 * const(size.yscale), 80 * const(size.yscale)]
triggerall = (fvar(30) = [-40, 80])||(p2movetype=I)
triggerall=random>500
triggerall=(prevstateno!=2000)
triggerall = PlayerID(var(35)),moveType !=A
triggerall=prevstateno!=[5120,5199]
trigger1   = Random < 100 + (PlayerID(var(35)),StateType =s) * 100;25 + (PlayerID(var(35)),StateType =s) * 35
trigger1   = ctrl
trigger2   = var(10) = 1
trigger2   = Random < 70;15
trigger3= (PrevStateNo =1100) 
Trigger3 = p2stateno = [120,159] 
Trigger3 = ctrl
trigger4=(stateno=100)&&(stateno=21)
;trigger4 = p2StateType = S
trigger4=random<900
trigger5=(prevstateno=900)&&(P2BodyDist X<=20)
;trigger5=InGuardDist=0
Trigger5 = ctrl
trigger6=prevstateno=[600,620]
trigger6=movehit
trigger7=prevstateno=[1000,1001]
trigger6=movehit
value      = 200



[State -1:          AI Stand Hard Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = (P2BodyDist X = [60,70])||((P2BodyDist X = [0,60])&&(p2StateNo = [5000,5059]))||((P2BodyDist X = [70,100])&&(PlayerID(var(35)),Vel x>0))||(StateNo = 100)
triggerall = P2BodyDist Y = [0,100];[-280 * const(size.yscale), 0 * const(size.yscale)]
triggerall = fvar(30) = [-70, 40]
triggerall=InGuardDist=0
triggerall=random>500
triggerall=(prevstateno!=2000)&&(stateno!=2000)
triggerall = PlayerID(var(35)),moveType !=A
trigger1   = Random < 65 + (PlayerID(var(35)),Vel Y) * 15 +35 - (PlayerID(var(35)),StateType = C) * 30
trigger1   = ctrl
trigger2   = var(10) = [1, 4]
trigger2   = Random < 25 * var(10)
trigger3=(PrevStateNo =[200,215])
Trigger3 = ctrl
trigger4=p2bodydist x =[70,100]
trigger4=(EnemyNear(0),Vel x>0)
trigger4=(random<500)
trigger4=ctrl
trigger5=(stateno=100)&&(stateno=21)
trigger5 = p2StateType = S
trigger5=(P2BodyDist X = [80,100])&&(PlayerID(var(35)),vel x >0)
trigger5=P2BodyDist Y  >=-10
trigger5=random<100
value      = 220

[State -1:          AI Stand Middle Attack, 2]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = PlayerIDExist(var(35))
triggerall = P2StateType != L
triggerall = (P2BodyDist X = [30,40])||((P2BodyDist X = [0,40])&&(p2StateNo = [5000,5059]))||(StateNo = 100);((P2BodyDist X = [60,80])&&(p2Statetype=A)&&(PlayerID(var(35)),vel x >0))
triggerall = (P2BodyDist Y = [-20,20])||((P2BodyDist X = [50,80])&&(P2BodyDist Y <=-100))
triggerall=p2statetype !=C
triggerall = fvar(30) = [-45, 30]
triggerall=random>500
triggerall=InGuardDist=0
triggerall=(prevstateno!=2000)
triggerall = PlayerID(var(35)),moveType !=A
trigger1   = Random < 15 + (PlayerID(var(35)),Vel Y) * 10
trigger1   = ctrl
trigger2   = var(10) = [1, 3]
trigger2   = Random < 15 * var(10)
trigger3 = P2statetype=A
trigger3= (P2BodyDist X = [70,100])&&((p2Statetype=A)&&(PlayerID(var(35)),vel x >0))||((P2BodyDist X = [50,80])&&(P2BodyDist Y <=-100))
trigger3=random<200
trigger3   = ctrl
trigger4=StateNo = 100
trigger4 = p2StateType = A
trigger4=(P2BodyDist X = [60,80])&&(PlayerID(var(35)),vel x >0)
trigger4=P2BodyDist Y  >=-10
trigger4=random<100
value      = 215

[State -1:          AI Stand Middle Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = (P2BodyDist X = [0,30])||((P2BodyDist X = [30,60])&&((PlayerID(var(35)),Vel x>0)||(p2movetype=A)))
triggerall = P2BodyDist Y = [-10,100];[-275 * const(size.yscale), 120 * const(size.yscale)]
;triggerall = fvar(30) = [-80, 80]
triggerall=(InGuardDist=0);||(P2BodyDist X = [30,55])
triggerall=random>500
triggerall=(prevstateno!=2000)
triggerall = PlayerID(var(35)),moveType !=A
trigger1   = Random < 30 + (PlayerID(var(35)),Vel Y) * 15 +10 + (PlayerID(var(35)),StateType = C) * 30;+ (PlayerID(var(35)),StateType = C) * 15
trigger1   = ctrl
trigger2   = var(10) = [1, 2]
trigger2   = Random < 35 * var(2)
trigger3=p2bodydist x =[40,55]
trigger3=(p2movetype=A)
trigger3=ctrl
trigger4=p2bodydist x =[40,50]
trigger4=((PlayerID(var(35)),Vel x>0)&&(random<500))
trigger4=ctrl
;trigger3=(PlayerID(var(35)),Vel x>0)
;trigger3=(random<200)
value      = 210
[State -1:          AI Stand Middle Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
;triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall=(InGuardDist=0);||(P2BodyDist X = [30,55])
triggerall = PlayerID(var(35)),moveType !=A
triggerall=PlayerID(var(35)),numproj <= 0 
TriggerALL = (PlayerID(var(35)),NumHelper <=Var(51))
trigger1   =NumHelper(7020)<4
trigger1   = Random < 50 
trigger1   =  P2BodyDist X-(PlayerID(var(35)),Vel X*20)  =[100,300]
trigger1=p2movetype!=H
trigger1   = ctrl
trigger2=(stateno=100)&&(stateno=21)
trigger2   =NumHelper(7020)<4
trigger2   = Random < 100 
trigger2   =  P2BodyDist X-(PlayerID(var(35)),Vel X*20)  =[100,300]
trigger2=p2movetype!=H
value      = 210

[State -1:          AI Stand Light Attack, 2]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = P2BodyDist X = [0,40];[0 * const(size.xscale), 165 * const(size.xscale)]
triggerall = P2BodyDist Y = [-200 * const(size.yscale), 0 * const(size.yscale)]
triggerall = fvar(30) = [-70, 30]
triggerall=(prevstateno!=2000)
triggerall=random>500
triggerall = PlayerID(var(35)),moveType !=A
trigger1   = Random < 40 + (PlayerID(var(35)),Vel Y) * 10;25 + (PlayerID(var(35)),Vel Y) * 10
trigger1   = ctrl
trigger2   = var(10) = 1
trigger2   = Random < 30 
trigger3= (PrevStateNo =610) 
Trigger3 = Movehit
Trigger3 = ctrl
trigger4=(prevstateno=900)&&(P2BodyDist X=[20,40])
Trigger4 = ctrl
trigger4=InGuardDist=0
value      = 205



;------------------------------------------------------------------------------;
; 通常攻撃 (空中)
;------------------------------------------------------------------------------;
[State -1:          AI Air Hard Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType = A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = (P2BodyDist X =[-5,20])||(((vel x>0)||(PlayerID(var(35)),vel x>0))&&(P2BodyDist X =[20,40])) ;= [0 * const(size.xscale), 135 * const(size.xscale)]
triggerall = P2BodyDist Y=[-60,10];(P2BodyDist Y-(vel y*10)-(PlayerID(var(35)),vel y*10) =[-60,10]);(P2BodyDist Y =[-70,50])||(((vel y<0)||(PlayerID(var(35)),vel y<0))&&(P2BodyDist y =[-90,70]))
;triggerall = (P2BodyDist Y = [-100,45])
;trigger1   = Random < 25 + (PlayerID(var(35)),HitFall) * 25
;trigger1   = ctrl
;trigger2   = var(10) = [1, 4]
;trigger2   = Random < 20 * var(10)
trigger1=(p2statetype=A)||(P2BodyDist X =[-5,5])
trigger1=p2bodydist x <40
trigger1=ctrl
value      = 620

[State -1:          AI Air Middle Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType = A
triggerall = PlayerIDExist(var(35))
triggerall = P2StateType != L
triggerall = (P2BodyDist X =[20,40])||(((vel x>0)||(PlayerID(var(35)),vel x>0))&&(P2BodyDist X =[40,60])) 
;triggerall = ( P2BodyDist x-(Vel x*7) = [0,45] );P2BodyDist X = [0,45];[0 * const(size.xscale), 170 * const(size.xscale)]
triggerall = (P2BodyDist Y=[0,50]);||(((vel y<0)||(PlayerID(var(35)),vel y<0))&&(P2BodyDist y =[-20,30]))
;triggerall = ( P2BodyDist Y=[0,50] );P2BodyDist Y >0;= [-100 * const(size.yscale), 100 * const(size.yscale)]
triggerall=(vel y>=0)||(p2StateType = A)
trigger1   = Random < 100;25 + (PlayerID(var(35)),StateType != A) * 35
trigger1   = ctrl
trigger2   = var(10) = [1, 2]
trigger2   = Random < 25 * var(10)
value      = 610

[State -1:          AI Air Light Attack]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType = A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = (P2BodyDist X =[-5,20])||(((vel x>0)||(PlayerID(var(35)),vel x>0))&&(P2BodyDist X =[0,40])) 
;triggerall = ( P2BodyDist x-(Vel x*7) = [0,20] );P2BodyDist X = [0,20];[0 * const(size.xscale), 120 * const(size.xscale)]
triggerall = (P2BodyDist Y=[0,40]);(P2BodyDist Y =[0,40])||(((vel y<0)||(PlayerID(var(35)),vel y<0))&&(P2BodyDist y =[-20,20]))
;triggerall = ( P2BodyDist Y=[0,40] );P2BodyDist Y >0;= [-80 * const(size.yscale), 100 * const(size.yscale)]
triggerall=p2statetype!=C
triggerall=(vel y>=0)||(p2StateType = A)
trigger1   = Random < 100;35 + (PlayerID(var(35)),StateType != A) * 50;25
trigger1   = ctrl
trigger2   = var(10) = 1
trigger2   = Random < 15
value      = 600

;==============================================================================;
; 必殺攻撃
;==============================================================================;
;------------------------------------------------------------------------------;
; 清流斬撃
;------------------------------------------------------------------------------;
[State -1:          AI 清流斬撃]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = (P2BodyDist X = [30,110])|| ((p2StateNo = [5000,5059])&&(P2BodyDist X = [0,100]) )
triggerall=  P2BodyDist Y+(PlayerID(var(35)),Vel Y*12) = [-10,15];((P2BodyDist Y>=0)&&(PlayerID(var(35)),Vel Y<0))||((P2BodyDist Y=[-30,-10])&&(PlayerID(var(35)),Vel Y>0))||((P2BodyDist Y=[-20,0])&&(PlayerID(var(35)),Vel Y=0))
triggerall = fvar(30) = [-70, 70]
triggerall = P2moveType !=A
Triggerall = p2StateNo != [5100,5199]
triggerall=(prevstateno!=2000)
triggerall=(stateno!=220)||((stateno=220)&&(movehit))
trigger1=p2stateno != [120,159]
trigger1   = ctrl
trigger1   = (p2StateNo = [5000,5059]);20 + (PlayerID(var(35)),StateType = A) * 10 + (PlayerID(var(35)),HitFall) * 20 
trigger2   = var(10)
trigger2=p2stateno != [120,159]
trigger2   = (p2StateNo = [5000,5059]);* var(10)|| (p2StateNo = [5000,5059]) 
value      = 1200

[State -1:          AI 清流斬撃];;;;;;;;
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall = P2StateType != L
triggerall = PlayerIDExist(var(35))
triggerall = (P2BodyDist X = [100,300])||((P2BodyDist X = [0,300])&&(p2StateNo = [5000,5059]))
triggerall= P2BodyDist Y+(PlayerID(var(35)),Vel Y*20) = [-10,15];((P2BodyDist Y>=0)&&(PlayerID(var(35)),Vel Y<0))||((P2BodyDist Y=[-40,-20])&&(PlayerID(var(35)),Vel Y>0))||((P2BodyDist Y=[-30,0])&&(PlayerID(var(35)),Vel Y=0))
triggerall = fvar(30) = [-70, 70]
Triggerall = p2StateNo != [5100,5199]
triggerall=(prevstateno!=2000)
triggerall=(stateno!=220)||((stateno=220)&&(movehit))
trigger1 = P2moveType !=A
trigger1   = ctrl
trigger1   =  (p2StateNo = [5000,5059])||((p2StateType = A)&&(random<30))||((stateno=[(var(59) + 210),(var(59) + 220)])&&(p2bodydist X >100)&&(random<30));(P2moveType = H );20 + (PlayerID(var(35)),StateType = A) * 10 + (PlayerID(var(35)),HitFall) * 20 
trigger2 = P2moveType !=A
trigger2   = var(10)
trigger2   = (p2StateNo = [5000,5059])||((p2StateType = A)&&(random<30))||((stateno=[(var(59) + 210),(var(59) + 220)])&&(p2bodydist X >100)&&(random<30))
trigger3=stateno=[120,159];[(var(59) + 210),(var(59) + 220)]
trigger3=(P2BodyDist X = [100,300])
trigger3=random<50
trigger3=ctrl
trigger4 = P2moveType !=A
trigger4=(PlayerID(var(35)),numproj <= 0) || (PlayerID(var(35)),NumHelper <=Var(51))
trigger4=(P2BodyDist X = [250,300])
trigger4=ctrl
value      = 1202




;------------------------------------------------------------------------------;
; 残空の太刀
;------------------------------------------------------------------------------;
[State -1:          AI 残空の太刀]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall=(P2BodyDist X=[130,132])|| (( (frontEdgebodyDist)-(p2bodydist x)<20)&&(P2BodyDist x =[80,130]))
trigger1=p2statetype=C
trigger1   = (Random < 5 + (PlayerID(var(35)),NumProj > 0) * 15 + ((PlayerID(var(35)),MoveType = A) && (P2BodyDist X > (160 * const(size.xscale)))) * 30)||(p2stateno != [120,159])
trigger1   = ctrl
;trigger2   = var(10)
;trigger2   = (Random < 5 + (PlayerID(var(35)),NumProj > 0) * 15 + ((PlayerID(var(35)),MoveType = A) && (P2BodyDist X > (160 * const(size.xscale)))) * 30)||(p2stateno != [120,159])
trigger2=(stateno=[(var(59) + 210),(var(59) + 220)])||(stateno=1500)
trigger2=ctrl
trigger2=p2statetype=C
trigger3=p2movetype=A
trigger3=random<100
trigger3=ctrl
trigger4=prevstateno=1500
value      = 1402;1400 + (Random % 3)
[State -1:          AI 残空の太刀]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall=(P2BodyDist X = [78,80]) || (( (frontEdgebodyDist)-(p2bodydist x)<20)&&(P2BodyDist x <80))
trigger1=p2statetype=C
trigger1   = (Random < 5 + (PlayerID(var(35)),NumProj > 0) * 15 + ((PlayerID(var(35)),MoveType = A) && (P2BodyDist X > (160 * const(size.xscale)))) * 30)||(p2stateno != [120,159])
trigger1   = ctrl
;trigger2   = var(10)
;trigger2   = (Random < 5 + (PlayerID(var(35)),NumProj > 0) * 15 + ((PlayerID(var(35)),MoveType = A) && (P2BodyDist X > (160 * const(size.xscale)))) * 30)||(p2stateno != [120,159])
trigger3=(stateno=[(var(59) + 210),(var(59) + 220)])||(stateno=1500)
trigger3=p2statetype=C
trigger3=p2StateNo != [5000,5059]
trigger3=((p2bodydist x =[45,75])&&(random<50))||(random<30)
trigger3=ctrl
trigger4=(stateno=100)&&(stateno=21)
trigger4=random<100
trigger4=(p2movetype!=H)&&(p2statetype!=L)
value      = 1401

[State -1:          AI 残空の太刀]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType != A
triggerall=p2movetype ! =H   ;||  P2BodyDist X >50
trigger1=partner,pos x -pos x >10 
trigger1 = partner,pos x - PlayerID(var(35)),pos x <0
trigger1=partner,life>1
trigger1=P2BodyDist X =[85,160]
trigger1=P2BodyDist X !=[200,300]
trigger1=random<70
trigger1   = ctrl
trigger2=p2movetype=A
trigger2=P2BodyDist X =[90,160]
trigger2=P2BodyDist X !=[170,300]
trigger2=P2BodyDist X !=[0,90]
trigger2=random<70
trigger2   = ctrl
;trigger3=ctrl
;trigger3=p2bodydist x =[50,120]
;trigger3=stateno=[(var(59) + 210),(var(59) + 220)]
;trigger3=random<100
;trigger4=prevstateno=1500
;trigger4=ctrl
trigger3=p2bodydist x =[70,80]
trigger3=StateNo = 100
trigger3=random=[200,300]
trigger3=(p2movetype!=H)&&(p2statetype!=L)
trigger4=stateno=1500
trigger4=p2movetype!=H
trigger4=p2movetype!=A
trigger4=p2bodydist x =[50,100]
trigger4=random<50
value      = 1400

;------------------------------------------------------------------------------;
; 急降下
;------------------------------------------------------------------------------;
[State -1:          AI 急降下]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType = A
triggerall = (P2BodyDist x = [20,32])||(( (frontEdgebodyDist)-(p2bodydist x)<20)&&(P2BodyDist x <=40));Vel X = [0,60]
triggerall = p2StateType != A;Pos Y < (0 - Abs(const(movement.airjump.height)))
triggerall = pos y <-50;p2Statetype = C || (fvar(30) = [0, 60] )
trigger1   = (Random < 300 + (PlayerID(var(35)),StateType = C) * 600)|| (p2StateNo = [5000,5059]);40
trigger1   = ctrl
trigger2   = var(10)            ; 通常技キャンセル
trigger2   = (Random < 300 * var(10))|| (p2StateNo = [5000,5059])
trigger3=(p2StateNo =[5120,5199] )&&(time=10)
trigger3   = ctrl
value      = 1001;1000 + (Random % 2)
[State -1:          AI 急降下]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType = A
triggerall = (P2BodyDist x =[-5,20])||(( (frontEdgebodyDist)-(p2bodydist x)<20)&&(P2BodyDist x <=20));Vel X = [0,60]
triggerall = p2StateType != A;Pos Y < (0 - Abs(const(movement.airjump.height)))
triggerall = pos y <-50;p2Statetype = C || (fvar(30) = [0, 70])
trigger1   = (Random < 500 + (PlayerID(var(35)),StateType = C) * 500)|| (p2StateNo = [5000,5059]);10 + (PlayerID(var(35)),StateType = C) * 80;40
trigger1   = ctrl
trigger2   = var(10)            ; 通常技キャンセル
trigger2   = (Random < 300 * var(10))|| (p2StateNo = [5000,5059])
trigger3=(p2StateNo =[5120,5199] )&&(time=10)
trigger3   = ctrl
value      = 1000;1000 + (Random % 2)

;------------------------------------------------------------------------------;
; 投げ
;------------------------------------------------------------------------------;
[State -1:          AI Throw]
type       = ChangeState
triggerall = !IsHelper
triggerall = var(59)
triggerall = RoundState = 2 && Alive
triggerall = StateType = S
triggerall = P2StateType != L
triggerall = P2BodyDist X =[0,20] ;[-70 * const(size.xscale), 150 * const(size.xscale)-5]
triggerall = PlayerIDExist(var(35))
triggerall = PlayerID(var(35)),moveType != H
triggerall   = PlayerID(var(35)),MoveType != A
triggerall   = PlayerID(var(35)),stateType != C
triggerall   = PlayerID(var(35)),StateType != A
triggerall=InGuardDist=0
trigger1 = ctrl
trigger1   = Random < 35
trigger2 = ctrl
trigger2   = PlayerID(var(35)),StateNo = [130, 131]
trigger2   = Random < 95
trigger3 = ctrl
trigger3= PlayerID(var(35)),stateno = [120,159]
trigger3=random<500
trigger4=(stateno=100)&&(stateno=21)
trigger4= PlayerID(var(35)),stateno = [120,159]
trigger4=random<500
value      = 500


;==============================================================================;
; システム
;==============================================================================;
;------------------------------------------------------------------------------;
; リフレクト
;------------------------------------------------------------------------------;
;[State -1:          AI Stand Reflect]
;type       = ChangeState
;triggerall = !IsHelper
;triggerall = var(59)
;triggerall = RoundState = 2 && Alive
;triggerall = StateType != A
;triggerall = PlayerIDExist(var(35))
;triggerall = (StateNo != 900) && (prevStateNo != 900)
;triggerall = ctrl
;trigger1   = InGuardDist
;;trigger1   = PlayerID(var(35)),MoveType = A
;trigger1   = p2statetype=S;PlayerID(var(35)),HitDefAttr = SA, NA, SA, HA
;trigger1   = Random < var(57)*100
;value      = 900

;[State -1:          AI Crouch Reflect]
;type       = ChangeState
;triggerall = !IsHelper
;triggerall = var(59)
;triggerall = RoundState = 2 && Alive
;triggerall = StateType != A
;triggerall = (StateNo != 910) && (prevStateNo != 910)
;triggerall = ctrl
;trigger1   = InGuardDist
;;trigger1   = PlayerID(var(35)),MoveType = A
;trigger1   = p2statetype=C;PlayerID(var(35)),HitDefAttr = C, NA, SA, HA

;trigger1   = Random < var(57)*100
;value      = 910

;[State -1:          AI Air Reflect]
;type       = ChangeState
;triggerall = !IsHelper
;triggerall = var(59)
;triggerall = RoundState = 2 && Alive
;triggerall = StateType = A
;triggerall = (StateNo != 920) && (prevStateNo != 920)
;triggerall = ctrl
;trigger1   = InGuardDist
;;trigger1   = PlayerID(var(35)),MoveType = A
;;trigger1   = PlayerID(var(35)),HitDefAttr = SCA, NA, SA, HA
;trigger1   = Random < var(57)*100
;value      = 920










;==============================================================================;
;                             [ AI行動 ここまで ]                              ;
;==============================================================================;



;リフレクト頻度設定

[State :         VarSet, Reflect]
type     = VarSet
trigger1 = Time = 0
v        = 57
value    =5            ;(1～10)

;リフレクトキャンセル濁流

[State :         VarSet, Reflect]
type     = VarSet
trigger1 = Time = 0
v        = 52
value    =1            ;1で使用、0でなし

;サポートキャラの自重

[State :         VarSet, Reflect]
type     = VarSet
trigger1 = Time = 0
v        = 50
value    =0            ;1で自重、0で自重なし

;サポートキャラフライング防止
[State :         VarSet, support]
type     = VarSet
trigger1 = roundstate=2&&time=1
v        = 54
value    = 1    
[State :         VarSet, support]
type     = VarSet
trigger1 = roundstate=!2
v        = 54
value    = 0


[State -3, AI];敵ヘルパー確認;たぶん機能しているはず
type = VarSet
TriggerAll = Var(51) = 0
Trigger1   = PlayerID(var(35)), NumHelper > 0
Trigger1   = RoundState = 1
Trigger1 = NumEnemy = 1
V = 51
Value = PlayerID(var(35)), NumHelper

;==============================================================================;
; Last Revision : $Rev$
; Last Modified : $Date$
;==============================================================================;
